/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.core;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.core.DescribedAs;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribedAsTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return DescribedAs.describedAs((String)"irrelevant", (Matcher)IsAnything.anything(), (Object[])new Object[0]);
    }

    public void testOverridesDescriptionOfOtherMatcherWithThatPassedToConstructor() {
        Matcher m1 = DescribedAs.describedAs((String)"m1 description", (Matcher)IsAnything.anything(), (Object[])new Object[0]);
        Matcher m2 = DescribedAs.describedAs((String)"m2 description", (Matcher)IsNot.not((Matcher)IsAnything.anything()), (Object[])new Object[0]);
        DescribedAsTest.assertDescription("m1 description", m1);
        DescribedAsTest.assertDescription("m2 description", m2);
    }

    public void testAppendsValuesToDescription() {
        Matcher m = DescribedAs.describedAs((String)"value 1 = %0, value 2 = %1", (Matcher)IsAnything.anything(), (Object[])new Object[]{33, 97});
        DescribedAsTest.assertDescription("value 1 = <33>, value 2 = <97>", m);
    }

    public void testDelegatesMatchingToAnotherMatcher() {
        Matcher m1 = DescribedAs.describedAs((String)"irrelevant", (Matcher)IsAnything.anything(), (Object[])new Object[0]);
        Matcher m2 = DescribedAs.describedAs((String)"irrelevant", (Matcher)IsNot.not((Matcher)IsAnything.anything()), (Object[])new Object[0]);
        DescribedAsTest.assertTrue((boolean)m1.matches(new Object()));
        DescribedAsTest.assertFalse((boolean)m2.matches((Object)"hi"));
    }

    public void testDelegatesMismatchDescriptionToAnotherMatcher() {
        Matcher m1 = DescribedAs.describedAs((String)"irrelevant", (Matcher)IsEqual.equalTo((Object)2), (Object[])new Object[0]);
        StringDescription description = new StringDescription();
        m1.describeMismatch((Object)1, (Description)description);
        DescribedAsTest.assertEquals((String)"was <1>", (String)description.toString());
    }
}

